-- 1. a)
select *
  from dept d
  join (select deptno, count(*) anzahl, rank() over (order by count(*) desc) rang
          from emp
         group by deptno) m
    on d.deptno = m.deptno and m.rang = 1;
    
-- 1. b)
select e.ename, e.job, m.anzahl
  from emp e
  join (select deptno, count(*) anzahl, rank() over (order by count(*) desc) rang
          from emp
         group by deptno) m
    on e.deptno = m.deptno and m.rang = 1;
    
--2. a)
select ename, job, sal
  from emp
 where sal > (select sal
                from emp
               where ename = 'SCOTT');

-- 2. b)
-- Es ist nicht klar, ob SCOTT eindeutig ist. In unseren Daten ist das zwar so, 
-- doch kann das nicht vorausgesetzt werden. Ist SCOTT nicht vorhanden, wird kein
-- Datensatz geliefert, schlimmer wäre aber, wenn es mehrere SCOTT im Unternehmen gäbe,
-- dann liefert die Abfrage oben einen Fehler.
-- Ein Ausweg wäre die Verwendung von ALL oder ANY bzw. die Berechnung des 
-- Minimal- oder Maximalgehalts aller Mitarbeiter dieses Namens.

-- 3. a)
select add_months(to_date('01.01.1980', 'dd.mm.yyyy'), rownum - 1) monat
  from all_objects
 where rownum < 37;
 
-- 3. b)
select d.monat, count(e.empno) einstellungen, 
       sum(count(e.empno)) over (order by d.monat) anzahl
  from (select add_months(to_date('01.01.1980', 'dd.mm.yyyy'), rownum - 1) monat
          from all_objects
         where rownum < 37) d
  left join emp e
    on d.monat = trunc(e.hiredate, 'MM')
 group by d.monat
 order by d.monat;

-- 4.
-- Ein Weg führt über die Verwendung der EXISTS-Klausel, auf die ich bei der Aufgabe
-- abgehoben habe. Andere Varianten sind auch denkbar.
select *
  from dept d
 where exists (select 1
                 from emp e
                where e.deptno = d.deptno
                  and e.job = 'SALESMAN');

-- 5.
select deptno, ename, job, sal,
       (select count(*)
          from emp a
         where a.deptno = e.deptno) anzahl
  from emp e
 order by deptno, ename;